implementation module clCrossCall

import StdBool, StdClass, StdInt, StdMisc, StdString, StdTuple
import intrface

  //----------------------------------------------//
 //    Cursor related crosscalls                 //
//----------------------------------------------//

WinSetWindowCursor :: !HWND !Int !*OSToolbox -> *OSToolbox
WinSetWindowCursor hwnd cursorcode tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinSetWindowCursor") (Rq2Cci CcRqCHANGEWINDOWCURSOR hwnd cursorcode) tb)

WinObscureCursor :: !*OSToolbox -> *OSToolbox
WinObscureCursor tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinObscureCursor") (Rq0Cci CcRqOBSCURECURSOR) tb)


  //----------------------------------------------//
 //    Dialog related crosscalls                 //
//----------------------------------------------//

WinBeep :: !*OSToolbox -> *OSToolbox
WinBeep tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinBeep") (Rq0Cci CcRqBEEP) tb)

//	PA: new routine to hide (False) and show (True) controls.
WinShowControl :: !HWND !Bool !*OSToolbox -> *OSToolbox
WinShowControl hwnd bool tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinShowControl") (Rq2Cci CcRqSHOWCONTROL hwnd (toInt bool)) tb)

WinEnableControl :: !HWND !Bool !*OSToolbox -> *OSToolbox
WinEnableControl hwnd bool tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinEnableControl") (Rq2Cci CcRqENABLECONTROL hwnd (toInt bool)) tb)

WinEnablePopupItem :: !HWND !Int !Bool !*OSToolbox -> *OSToolbox
WinEnablePopupItem hwnd pos bool tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinEnablePopupItem") (Rq3Cci CcRqENABLEPOPUPITEM hwnd pos (toInt bool)) tb)

WinCheckControl :: !HWND !Bool !*OSToolbox -> *OSToolbox
WinCheckControl hwnd bool tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinCheckControl") (Rq2Cci CcRqSETITEMCHECK hwnd (toInt bool)) tb)

WinSelectPopupItem :: !HWND !Int !*OSToolbox -> *OSToolbox
WinSelectPopupItem hwnd pos tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinSelectPopupItem") (Rq2Cci CcRqSELECTPOPUPITEM hwnd pos) tb)


  //----------------------------------------------//
 //    Timer related crosscalls                  //
//----------------------------------------------//

WinCreateTimer :: !Int !*OSToolbox -> (!HITEM,!*OSToolbox)
WinCreateTimer interval tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinCreateTimer") (Rq1Cci CcRqCREATETIMER interval) tb
	  hitem		= case rcci.ccMsg of
	  				CcRETURN1	-> rcci.p1
	  				CcWASQUIT	-> 0
					other		-> abort "[WinCreateTimer] expected CcRETURN1 value." 
	= (hitem,tb)

WinKillTimer :: !Int !*OSToolbox -> *OSToolbox
WinKillTimer id tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinKillTimer") (Rq1Cci CcRqKILLTIMER id) tb)

WinSetIdleTimer :: !Bool !*OSToolbox -> *OSToolbox
WinSetIdleTimer bool tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinSetIdleTimer") (Rq1Cci CcRqIDLETIMER (toInt bool)) tb)

WinGetTime :: !*OSToolbox -> (!(!Int,!Int,!Int),!*OSToolbox)
WinGetTime tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetTime") (Rq0Cci CcRqGETCURTIME) tb
	  time		= case rcci.ccMsg of
	  				CcRETURN3	-> (rcci.p1,rcci.p2,rcci.p3)
					CcWASQUIT	-> (0,0,0) 
					other		-> abort "[WinGetTime] expected CcRETURN3 value." 
	= (time,tb)

WinGetDate :: !*OSToolbox -> (!(!Int,!Int,!Int,!Int),!*OSToolbox)
WinGetDate tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetDate") (Rq0Cci CcRqGETCURDATE) tb
	  date		= case rcci.ccMsg of
					CcRETURN4	-> (rcci.p1,rcci.p2,rcci.p3,rcci.p4)
					CcWASQUIT	-> (0,0,0,1)
					other		-> abort "[WinGetDate] expected CcRETURN4 value."
	= (date,tb)

WinWait :: !Int !*OSToolbox -> *OSToolbox
WinWait i tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinWait") (Rq1Cci CcRqWAIT i) tb)

WinGetBlinkTime :: !*OSToolbox -> (!Int,!*OSToolbox)
WinGetBlinkTime tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetBlinkTime") (Rq0Cci CcRqGETBLINKTIME) tb
	  time		= case rcci.ccMsg of
					CcRETURN1	-> rcci.p1
					CcWASQUIT	-> 1
					other		-> abort "[WinGetBlinkTime] expected CcRETURN1 value."
	= (time,tb)


  //----------------------------------------------//
 //    Clipboard related crosscalls              //
//----------------------------------------------//

WinGetClipboardText :: !*OSToolbox -> (!String,!*OSToolbox)
WinGetClipboardText tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetClipboardText") (Rq0Cci CcRqGETCLIPBOARDTEXT) tb
	# (text,tb)	= case rcci.ccMsg of
					CcRETURN1	-> WinGetCStringAndFree rcci.p1 tb
					CcWASQUIT	-> ("",tb)
					other		-> abort "[WinGetClipboardText] expected CcRETURN1 value.\n"
	= (text,tb)

WinSetClipboardText :: !String !*OSToolbox -> *OSToolbox
WinSetClipboardText text tb
	# (textptr,tb)	= WinMakeCString text tb
	# (_,tb)		= IssueCleanRequest2 (ErrorCallback2 "SetClipboardText") (Rq1Cci CcRqSETCLIPBOARDTEXT textptr) tb
	= WinReleaseCString textptr tb

WinHasClipboardText :: !*OSToolbox -> (!Bool,!*OSToolbox)
WinHasClipboardText tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinHasClipboardText") (Rq0Cci CcRqCLIPBOARDHASTEXT) tb
	  ok		= case rcci.ccMsg of
	  				CcRETURN1	-> rcci.p1<>0
	  				CcWASQUIT	-> False
	  				_			-> abort "[WinHasClipboardText] expected CcRETURN1 value."
	= (ok,tb)


  //----------------------------------------------//
 //    Window related crosscalls                 //
//----------------------------------------------//

WinGetScrollWinFrameSize :: !HWND !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
WinGetScrollWinFrameSize hwnd tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetScrollWinFrameSize") (Rq1Cci CcRqGETSCROLLFRAME hwnd) tb
	  size		= case rcci.ccMsg of
					CcRETURN2	-> (rcci.p1,rcci.p2)
					CcWASQUIT	-> (0,0) 
					other		-> abort "[WinGetScrollWinFrameSize] expected CcRETURN2 value."
	= (size,tb)

WinGetClientSize :: !HWND !*OSToolbox -> (!(!Int,!Int), !*OSToolbox)
WinGetClientSize hwnd tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetClientSize") (Rq1Cci CcRqGETCLIENTSIZE hwnd) tb
	  size		= case rcci.ccMsg of
					CcRETURN2	-> (rcci.p1,rcci.p2)
					CcWASQUIT	-> (0,0) 
					other		-> abort "[WinGetClientSize] expected CcRETURN2 value."
	= (size,tb)

WinSetWindowSize :: !HWND !(!Int,!Int) !*OSToolbox -> *OSToolbox
WinSetWindowSize hwnd (w,h) tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinSetWindowSize") (Rq3Cci CcRqSETWINDOWSIZE hwnd w h) tb)

WinGetWindowPos :: !HWND !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
WinGetWindowPos hwnd tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetWindowPos") (Rq1Cci CcRqGETWINDOWPOS hwnd) tb
	  pos		= case rcci.ccMsg of
					CcRETURN2	-> (rcci.p1,rcci.p2)
					CcWASQUIT	-> (0,0) 
					other		-> abort "[WinGetWindowPos] expected CcRETURN2 value."
	= (pos,tb)

WinSetWindowPos :: !HWND !(!Int,!Int) !*OSToolbox -> *OSToolbox
WinSetWindowPos hwnd (x,y) tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinSetWindowPos") (Rq3Cci CcRqSETWINDOWPOS hwnd x y) tb)

WinGetWindowText :: !HWND !*OSToolbox -> (!String, !*OSToolbox)
WinGetWindowText hwnd tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetWindowText") (Rq1Cci CcRqGETWINDOWTEXT hwnd) tb
	# (text,tb)	= case rcci.ccMsg of
					CcRETURN1	-> WinGetCStringAndFree rcci.p1 tb
					CcWASQUIT	-> ("",tb)
					other		-> abort "[WinGetWindowText] expected CcRETURN1 value."
	= (text,tb)

WinSetWindowTitle :: !HWND !String !*OSToolbox -> *OSToolbox
WinSetWindowTitle hwnd title tb
	# (textptr,tb)	= WinMakeCString title tb
	# (_,tb)		= IssueCleanRequest2 (ErrorCallback2 "SetWindowTitle") (Rq2Cci CcRqSETWINDOWTITLE hwnd textptr) tb
	= WinReleaseCString textptr tb

WinInvalidateWindow :: !HWND !*OSToolbox -> *OSToolbox
WinInvalidateWindow hwnd tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinInvalidateWindow") (Rq1Cci CcRqINVALIDATEWINDOW hwnd) tb)

WinInvalidateRect :: !HWND !(!Int,!Int,!Int,!Int) !*OSToolbox -> *OSToolbox
WinInvalidateRect hwnd (left,top, right,bottom) tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "InvalidateRect") (Rq5Cci CcRqINVALIDATERECT hwnd left top right bottom) tb)

//	PA: new function to (en/dis)able windows.
WinSetSelectStateWindow :: !HWND !(!Bool,!Bool) !Bool !Bool !*OSToolbox -> *OSToolbox
WinSetSelectStateWindow hwnd (hasHScroll,hasVScroll) toAble modalContext tb
	# selectCci	= Rq5Cci CcRqSETSELECTWINDOW hwnd (toInt hasHScroll) (toInt hasVScroll) (toInt toAble) (toInt modalContext)
	= snd (IssueCleanRequest2 (ErrorCallback2 "SetSelectStateWindow") selectCci tb)

WinBeginPaint :: !HWND !*OSToolbox -> (!HDC,!*OSToolbox) 
WinBeginPaint hwnd tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "BeginPaint") (Rq1Cci CcRqBEGINPAINT hwnd) tb
	  hdc		= case rcci.ccMsg of
					CcRETURN1	-> rcci.p1
					CcWASQUIT	-> 0 
					other		-> abort "[WinBeginPaint] expected CcRETURN1 value."
	= (hdc,tb)

WinEndPaint :: !HWND !(!HDC, !*OSToolbox) -> *OSToolbox
WinEndPaint hwnd (hdc,tb)
	= snd (IssueCleanRequest2 (ErrorCallback2 "EndPaint") (Rq2Cci CcRqENDPAINT hwnd hdc) tb)

WinGetDC :: !HWND !*OSToolbox -> (!HDC,!*OSToolbox)
WinGetDC hwnd tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetDC") (Rq1Cci CcRqGETDC hwnd) tb
	  hdc		= case rcci.ccMsg of
					CcRETURN1	-> rcci.p1
					CcWASQUIT	-> 0 
					other		-> abort "[WinGetDC] expected CcRETURN1 value."
	= (hdc,tb)

WinReleaseDC :: !HWND !(!HDC,!*OSToolbox) -> *OSToolbox
WinReleaseDC hwnd (hdc,tb)
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinReleaseDC") (Rq2Cci CcRqRELEASEDC hwnd hdc) tb)

WinGetActiveDialog :: !*OSToolbox -> (!HWND,!*OSToolbox)
WinGetActiveDialog tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetActiveDialog") (Rq0Cci CcRqGETACTIVEDIALOG) tb
	  hwnd		= case rcci.ccMsg of
					CcRETURN1	-> rcci.p1
					CcWASQUIT	-> 0 
					other		-> abort "[WinGetActiveDialog] expected CcRETURN1 value."
	= (hwnd,tb)

WinGetForegroundWindow :: !*OSToolbox -> (!HWND,!*OSToolbox)
WinGetForegroundWindow tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinGetForegroundWindow") (Rq0Cci CcRqGETFOREGROUNDWINDOW) tb
	  hwnd		= case rcci.ccMsg of
					CcRETURN1	-> rcci.p1
					CcWASQUIT	-> 0 
					other		-> abort "[WinGetForegroundWindow] expected CcRETURN1 value."
	= (hwnd,tb)

WinSetScrollInfos :: !HWND !(!(!Int,!Int),!(!Int,!Int)) !(!Int,!Int,!Int,!Int) !*OSToolbox -> *OSToolbox
WinSetScrollInfos hwnd ((pl,pt),(pr,pb)) (width,height,hthumb,vthumb) tb
	# (_,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinSetScrollInfos") (Rq5Cci CcRqSETHSCROLLINFO hwnd pl pr hthumb width)  tb
	# (_,tb)	= IssueCleanRequest2 (ErrorCallback2 "WinSetScrollInfos") (Rq5Cci CcRqSETVSCROLLINFO hwnd pt pb vthumb height) tb
	= tb

/*	PA: three new functions to handle scrollbars.
*/
WinSetScrollRange :: !HWND !Int !Int !Int !Bool !*OSToolbox -> *OSToolbox
WinSetScrollRange scrollHWND iBar min max redraw tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinSetScrollRange") (Rq5Cci CcRqSETSCROLLRANGE scrollHWND iBar min max (toInt redraw)) tb)
	
WinSetScrollPos :: !HWND !Int !Int !Bool !*OSToolbox -> *OSToolbox
WinSetScrollPos scrollHWND iBar thumb redraw tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinSetScrollPos") (Rq4Cci CcRqSETSCROLLPOS scrollHWND iBar thumb (toInt redraw)) tb)

WinSetScrollThumbSize :: !HWND !Int !Int !Bool !*OSToolbox -> *OSToolbox
WinSetScrollThumbSize scrollHWND iBar size redraw tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinSetScrollThumbSize") (Rq4Cci CcRqSETSCROLLSIZE scrollHWND iBar size (toInt redraw)) tb)
/*	PA: end of addition.
*/

/*	PA: new functions to handle edit controls.
*/
WinSetEditSelection :: !HWND !Int !Int !*OSToolbox -> *OSToolbox
WinSetEditSelection editHWND first last tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinSetEditSelection") (Rq3Cci CcRqSETEDITSELECTION editHWND first last) tb)
/*	PA: end of addition.
*/

/*	PA: WinRestackWindow now as a crosscall operation.
*/
WinRestackWindow :: !HWND !HWND !*OSToolbox -> *OSToolbox
WinRestackWindow theWindow behindWindow tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "WinRestackWindow") (Rq2Cci CcRqRESTACKWINDOW theWindow behindWindow) tb)




  //----------------------------------------------//
 //    Menu related crosscalls                   //
//----------------------------------------------//

WinCreateMenuBarHandle :: !*OSToolbox -> (!HMENU,!*OSToolbox)
WinCreateMenuBarHandle tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "CreateMenuBarHandle") (Rq0Cci CcRqCREATEMBAR) tb
	  hmenu		= case rcci.ccMsg of
					CcRETURN1	-> rcci.p1
					CcWASQUIT	-> 0
					other		-> abort "[CreateMenuBarHandle] expected CcRETURN1 value."
	= (hmenu,tb)

WinCreateMenuWindow :: !HMENU !String !*OSToolbox -> (!HWND,!*OSToolbox)
WinCreateMenuWindow mbar wintitle tb
	# (textptr,tb)	= WinMakeCString wintitle tb
	# (rcci,tb)		= IssueCleanRequest2 (ErrorCallback2 "CreateMenuWindow") (Rq2Cci CcRqCREATEMENUWINDOW mbar textptr) tb
	  hwnd			= case rcci.ccMsg of
						CcRETURN1	-> rcci.p1
						CcWASQUIT	-> 0 
						other		-> abort "[CreateMenuWindow] expected CcRETURN1 value."
	# tb			= WinReleaseCString textptr tb
	= (hwnd,tb)

WinCreatePopupMenuHandle :: !*OSToolbox -> (!HMENU,!*OSToolbox)
WinCreatePopupMenuHandle tb
	# (rcci,tb)	= IssueCleanRequest2 (ErrorCallback2 "CreatePopupMenuHandle ") (Rq0Cci CcRqCREATEPOPMENU) tb
	  hmenu		= case rcci.ccMsg of
					CcRETURN1	-> rcci.p1
					CcWASQUIT	-> 0
					other		-> abort "[CreatePopupMenuHandle] expected CcRETURN1 value."
	= (hmenu,tb)

WinInsertMenu :: !String !Bool !HMENU !HMENU !Int !*OSToolbox -> *OSToolbox
WinInsertMenu text state submenu menu pos tb
	# (textptr,tb)	= WinMakeCString text tb
	# (_,tb)		= IssueCleanRequest2 (ErrorCallback2 "AppendMenu") (Rq5Cci CcRqINSERTMENU (toInt state) menu textptr submenu pos) tb
	= WinReleaseCString textptr tb

WinAppendMenu :: !String !Bool !HMENU !HMENU !*OSToolbox -> *OSToolbox
WinAppendMenu text state submenu menu tb
	# (textptr,tb)	= WinMakeCString text tb
	# (_,tb)		= IssueCleanRequest2 (ErrorCallback2 "AppendMenu") (Rq4Cci CcRqAPPENDMENU (toInt state) menu textptr submenu) tb
	= WinReleaseCString textptr tb

WinAppendMenuItem :: !String !Bool !Bool !HMENU !*OSToolbox -> (!HITEM,!*OSToolbox)
WinAppendMenuItem text ablestate markstate menu tb
	# (textptr,tb)	= WinMakeCString text tb
	  appendCci		= Rq4Cci CcRqAPPENDMENUITEM (toInt ablestate) menu textptr (toInt markstate)
	# (rcci,tb)		= IssueCleanRequest2 (ErrorCallback2 "AppendMenuItem") appendCci tb
	  hitem			= case rcci.ccMsg of
						CcRETURN1	-> rcci.p1
						CcWASQUIT	-> 0 
						other		-> abort "[WinAppendMenuItem] expected CcRETURN1 value."
	# tb			= WinReleaseCString textptr tb
	= (hitem,tb)

WinAppendSeparator :: !HMENU !*OSToolbox -> *OSToolbox
WinAppendSeparator menu tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "AppendSeparator") (Rq1Cci CcRqAPPENDSEPARATOR menu) tb)

WinInsertMenuItem :: !String !Bool !Bool !HMENU !Int !*OSToolbox -> (!HITEM,!*OSToolbox)
WinInsertMenuItem text ablestate markstate menu pos tb
	# (textptr,tb)	= WinMakeCString text tb
	  insertCci		= Rq5Cci CcRqINSERTMENUITEM (toInt ablestate) menu textptr (toInt markstate) pos
	# (rcci,tb)		= IssueCleanRequest2 (ErrorCallback2 "InsertMenuItem") insertCci tb
	  hitem			= case rcci.ccMsg of
						CcRETURN1	-> rcci.p1
						CcWASQUIT	-> 0
						other		-> abort "[WinInsertMenuItem] expected CcRETURN1 value."
	# tb			= WinReleaseCString textptr tb
	= (hitem,tb)

WinInsertSeparator :: !HMENU !Int !*OSToolbox -> *OSToolbox
WinInsertSeparator menu pos tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "InsertSeparator") (Rq2Cci CcRqINSERTSEPARATOR menu pos) tb)

WinChangeMenuItemCheck :: !HMENU !HITEM !Bool !*OSToolbox -> *OSToolbox
WinChangeMenuItemCheck menu hitem state tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "CheckMenuItem") (Rq3Cci CcRqCHECKMENUITEM menu hitem (toInt state)) tb)

WinModifyMenu :: !String !HMENU !HMENU !*OSToolbox -> *OSToolbox
WinModifyMenu text submenu menu tb
	# (textptr,tb)	= WinMakeCString text tb
	# (_,tb)		= IssueCleanRequest2 (ErrorCallback2 "ModifyMenu") (Rq3Cci CcRqMODIFYMENU submenu menu textptr) tb
	= WinReleaseCString textptr tb

WinModifyMenuItem :: !String !HITEM !HMENU !*OSToolbox -> *OSToolbox
WinModifyMenuItem text hitem menu tb
	# (textptr,tb)	= WinMakeCString text tb
	# (_,tb)		= IssueCleanRequest2 (ErrorCallback2 "ModifyMenuItem") (Rq3Cci CcRqMODIFYMENUITEM hitem menu textptr) tb
	= WinReleaseCString textptr tb

WinDestroyMenu :: !HMENU !*OSToolbox -> *OSToolbox
WinDestroyMenu menu tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "DestroyMenu") (Rq1Cci CcRqDESTROYMENU menu) tb)

WinDeleteMenu :: !HMENU !HITEM !*OSToolbox -> *OSToolbox
WinDeleteMenu menu hitem tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "DeleteMenu") (Rq2Cci CcRqDELETEMENU menu hitem) tb)

WinRemoveMenuItem :: !HMENU !HITEM !*OSToolbox -> *OSToolbox
WinRemoveMenuItem menu hitem tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "RemoveMenuItem") (Rq2Cci CcRqREMOVEMENUITEM menu hitem) tb)

WinChangeItemAbility :: !HMENU !HITEM !Bool !*OSToolbox -> *OSToolbox
WinChangeItemAbility parent hitem onoff tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "ChangeItemAbility") (Rq3Cci CcRqITEMENABLE parent hitem (toInt onoff)) tb)

WinChangeMenuAbility :: !HMENU !Int !Bool !*OSToolbox -> *OSToolbox
WinChangeMenuAbility parent zIndex onoff tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "ChangeMenuAbility") (Rq3Cci CcRqMENUENABLE parent zIndex (toInt onoff)) tb)

WinDrawMenuBar :: !*OSToolbox -> *OSToolbox
WinDrawMenuBar tb
	= snd (IssueCleanRequest2 (ErrorCallback2 "DrawMenuBar") (Rq0Cci CcRqDRAWMBAR) tb)


  //----------------------------------------------//
 //    Crosscall infrastructure                  //
//----------------------------------------------//


//	PA: this is neither exported nor used.
//  :: Callback s :== !CrossCallInfo !s -> *(*OSToolbox -> (Bool, CrossCallInfo, s, *OSToolbox))

//	PA: restructured IssueCleanRequest for readability.
//	2 versions: first without Iprint statements, second with Iprint statements.
//	In both cases the Bool result has also been eliminated as it is never used.
IssueCleanRequest :: !(CrossCallInfo -> .(.s -> .(*OSToolbox -> *(.CrossCallInfo,.s,*OSToolbox))))
                     !.CrossCallInfo !.s !*OSToolbox -> (!CrossCallInfo,!.s,!*OSToolbox)
IssueCleanRequest callback cci s tb
	# (reply,tb)	= WinKickOsThread cci tb
	= HandleCallBacks callback reply s tb
where
	HandleCallBacks :: !(CrossCallInfo -> .(.s -> .(*OSToolbox -> *(.CrossCallInfo,.s,*OSToolbox))))
					   !CrossCallInfo !.s !*OSToolbox -> (!CrossCallInfo,!.s,!*OSToolbox)
	HandleCallBacks callback cci=:{ccMsg} s tb
		| ccMsg>2000
			= abort ("HandleCallBacks "+++toString ccMsg)
		| IsReturnOrQuitCci ccMsg
			= (cci,s,tb)
		# (returnCci,s,tb)	= callback cci s tb
		# (replyCci,tb)		= WinKickOsThread returnCci tb
		| otherwise
			= HandleCallBacks callback replyCci s tb
/*
IssueCleanRequest callback cci s tb
	# (reply,tb)	= Iprint "<<ICR:WinKickOsThread>>" WinKickOsThread cci tb
	# tb			= Iprint "<<ICR:os2>>" tb
	# result		= Iprint "<<ICR:HandleCallbacks>>" HandleCallBacks reply s tb
	= result
where
	HandleCallbacks :: !CrossCallInfo !.s !*OSToolbox -> (!CrossCallInfo,!.s,!*OSToolbox)
	HandleCallBacks cci=:(message_kind,_,_,_,_,_,_) s tb
		| message_kind>2000
			= abort ("HandleCallBacks "+++toString message_kind)
		| IsReturnOrQuitCci message_kind
			= (cci,s,tb)
		# (returnCci,s,tb)	= callback cci s tb
		# tb				= Iprint "<<HCB: os2>>" tb
		# returnCci			= Iprint "<<HCB: returnCci>>" returnCci
		# (replyCci,tb)		= Iprint "<<HCB: WinKickOsThread>>" WinKickOsThread returnCci tb
		# tb				= Iprint "<<HCB: newos>>" tb
		# result			= Iprint "<<HCB: HandleCallbacks>>" HandleCallBacks replyCci s tb
		// otherwise
			= result
*/
/*	PA: previous version of IssueCleanRequest.
IssueCleanRequest callback cci s os = result
where
	(cci2, os2)	=  Iprint "<<ICR:WinKickOsThread>>" WinKickOsThread cci os
	result		=  Iprint "<<ICR:HandleCallbacks>>" HandleCallBacks cci2 s (Iprint "<<ICR:os2>>" os2)

	HandleCallBacks cci=:(message_kind,_,_,_,_,_,_) s os
	
	| message_kind > 2000
		= abort ("HandleCallBacks "+++toString message_kind);
	
	| IsReturnOrQuitCci message_kind  =   ( cci, s, os)
	// otherwise	=   Iprint "<<HCB:HandleCallbacks>>" HandleCallBacks newcci news (Iprint "<<HCB:newos>>" newos)
	where
		(_, returncci, news, os2) = callback cci s os
		(newcci, newos)	  = Iprint "<<HCB:WinKickOsThread>>" WinKickOsThread (Iprint "<<HCB: returnCci>>" returncci) ( Iprint "<<HCB: os2>>" os2)
*/

/*	PA: version of IssueCleanRequest that has no state parameter.
*/
IssueCleanRequest2 :: !(CrossCallInfo -> .(*OSToolbox -> *(.CrossCallInfo,*OSToolbox))) !.CrossCallInfo !*OSToolbox
																					 -> (!CrossCallInfo,!*OSToolbox)
IssueCleanRequest2 callback cci tb
	# (reply,tb)	= WinKickOsThread cci tb
	= HandleCallBacks callback reply tb
where
	HandleCallBacks :: !(CrossCallInfo -> .(*OSToolbox -> *(.CrossCallInfo,*OSToolbox))) !CrossCallInfo !*OSToolbox
																					 -> (!CrossCallInfo,!*OSToolbox)
	HandleCallBacks callback cci=:{ccMsg} tb
		| ccMsg>2000
			= abort ("HandleCallBacks "+++toString ccMsg)
		| IsReturnOrQuitCci ccMsg
			= (cci,tb)
		# (returnCci,tb) = callback cci tb
		# (replyCci, tb) = WinKickOsThread returnCci tb
		| otherwise
			= HandleCallBacks callback replyCci tb

//	PA: macros for returning proper number of arguments within a CrossCallInfo.
Rq0Cci msg :== {ccMsg=msg,p1=0,p2=0,p3=0,p4=0,p5=0,p6=0}
Rq1Cci msg v1 :== {ccMsg=msg,p1=v1,p2=0,p3=0,p4=0,p5=0,p6=0}
Rq2Cci msg v1 v2 :== {ccMsg=msg,p1=v1,p2=v2,p3=0,p4=0,p5=0,p6=0}
Rq3Cci msg v1 v2 v3 :== {ccMsg=msg,p1=v1,p2=v2,p3=v3,p4=0,p5=0,p6=0}
Rq4Cci msg v1 v2 v3 v4 :== {ccMsg=msg,p1=v1,p2=v2,p3=v3,p4=v4,p5=0,p6=0}
Rq5Cci msg v1 v2 v3 v4 v5 :== {ccMsg=msg,p1=v1,p2=v2,p3=v3,p4=v4,p5=v5,p6=0}
Rq6Cci msg v1 v2 v3 v4 v5 v6 :== {ccMsg=msg,p1=v1,p2=v2,p3=v3,p4=v4,p5=v5,p6=v6}

Return0Cci :: CrossCallInfo
Return0Cci = Rq0Cci CcRETURN0

Return1Cci :: !Int -> CrossCallInfo
Return1Cci v = Rq1Cci CcRETURN1 v

Return2Cci :: !Int !Int -> CrossCallInfo
Return2Cci v1 v2 = Rq2Cci CcRETURN2 v1 v2

Return3Cci :: !Int !Int !Int -> CrossCallInfo
Return3Cci v1 v2 v3 = Rq3Cci CcRETURN3 v1 v2 v3

Return4Cci :: !Int !Int !Int !Int -> CrossCallInfo
Return4Cci v1 v2 v3 v4 = Rq4Cci CcRETURN4 v1 v2 v3 v4

Return5Cci :: !Int !Int !Int !Int !Int -> CrossCallInfo
Return5Cci v1 v2 v3 v4 v5 = Rq5Cci CcRETURN5 v1 v2 v3 v4 v5

Return6Cci :: !Int !Int !Int !Int !Int !Int -> CrossCallInfo
Return6Cci v1 v2 v3 v4 v5 v6 = Rq6Cci CcRETURN6 v1 v2 v3 v4 v5 v6

IsReturnOrQuitCci :: !Int -> Bool
IsReturnOrQuitCci mess
	= mess==CcWASQUIT || (mess<=CcRETURNmax && mess>=CcRETURNmin)

instance toInt Bool where
	toInt :: !Bool -> Int
	toInt True = -1
	toInt _    = 0

ErrorCallback :: !String !CrossCallInfo !.s !*OSToolbox -> (!CrossCallInfo, !.s, !*OSToolbox)
ErrorCallback source cci s tb
	= (Return0Cci, s, Iprint msgtext tb)
where
	msgtext	= " *** [" +++ source +++ "] did not expect a callback: " +++ toString cci.ccMsg

//	PA: version of ErrorCallback without state parameter (use with IssueCleanRequest2).
ErrorCallback2 :: !String !CrossCallInfo !*OSToolbox -> (!CrossCallInfo,!*OSToolbox)
ErrorCallback2 source cci tb
	= (Return0Cci,Iprint msgtext tb)
where
	msgtext	= " *** [" +++ source +++ "] did not expect a callback: " +++ toString cci.ccMsg


  //----------------------------------------------//
 //     Beeping and printing to out.txt          //
//----------------------------------------------//

Ibeep :: .a -> .a
Ibeep a 
  |  i == o = a
            = a
where
  i = 99
  o = WinBeep 99

/*
Iprint string a :== a
Iprint` string a :== a
*/

Iprint :: !String !.a -> .a
Iprint s a 
	| not (printresult == 0)  = a
							  = abort ("Print failed: " +++ s)
where
	printresult   = ConsolePrint ("## " +++ s +++ "\n") 999

Iprint` :: !String !.a -> .a
Iprint` s a 
	| not (printresult == 0)  = a
							  = abort ("Print failed: " +++ s)
where
	printresult   = ConsolePrint s 999
